/* SPOTLIGHTS */
$(function() {
  
  $('.spotlight-widget').live('setupwidget', function() {
    var spotlightWidget = $(this);
    var spotlightPanels = $('.panel', spotlightWidget);
    var spotlightItems = $('.playlist li', spotlightWidget)
    
    spotlightWidget.data('activePanel', spotlightPanels.first());
    spotlightWidget.data('activeItem', spotlightItems.first());
    
    if ($('.playlist .more', spotlightWidget).length < 1) {
      var itemsPadding = Math.floor((spotlightItems.parent().width() - ((64 + 8) * spotlightItems.length)) / 2);
      spotlightItems.parent().css('padding-left', itemsPadding);
    }
    
    spotlightItems.each(function() {
      $(this).removeClass('first').removeClass('last');
      var itemClass = $(this).attr('class');
      var panelClass = '.' + itemClass.replace('item', 'panel');
      var panel = $(panelClass, spotlightPanels.parent());
      $(panel).removeClass('first').removeClass('last');
      
      $(this).bind('showPanel', function() {
        var oldPanel = spotlightWidget.data('activePanel');
        var newPanel = $(panelClass, spotlightPanels.parent());
        var oldItem = spotlightWidget.data('activeItem');
        var newItem = $(this);
        
        if (newPanel.hasClass('active')) {
          return;
        }
        
        oldPanel.removeClass('active').fadeOut();
        oldItem.removeClass('active');
        newPanel.addClass('active').fadeIn();
        newItem.addClass('active');
        
        $('.content-background', newPanel).remove();
        var details = $('.content-details', newPanel);
        var mypanel = $('<div class="content-background"></div>');
        mypanel.css('height', details.outerHeight() + "px");
        mypanel.css('width', details.outerWidth() + "px");
        mypanel.css('top', details.css('top'));
        mypanel.css('left', details.css('left'));
        mypanel.css('bottom', details.css('bottom'));
        mypanel.css('right', details.css('right'));
        mypanel.insertBefore(details);
        
        spotlightWidget.data('activePanel', newPanel);
        spotlightWidget.data('activeItem', newItem);
      });
    });
    
    spotlightWidget.bind('nextPanel', function() {
      var nextItem = spotlightWidget.data('activeItem').next('li');
      
      if (nextItem.length == 0) {
        nextItem = spotlightItems.first();
      }
      
      $(nextItem).trigger('showPanel');
    });
  
    spotlightItems.click(function() {
      $(this).trigger("showPanel");
      clearInterval(spotlightWidget.data('timer'));
    });
    
    spotlightItems.first().trigger("showPanel");
    
    spotlightWidget.data('timer', setInterval(function() {
      spotlightWidget.trigger('nextPanel');
    }, 7000));  
    
  });

  $(window).load(function() {
    $('.spotlight-widget').trigger('setupwidget');  
  });
  
  
});
